<!-- views/ordens_servico/listar.php -->
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ordens de Serviço</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-100 font-sans">
    <nav class="bg-blue-600 p-4 text-white flex justify-between">
        <h1 class="text-lg font-bold">Sistema de Gestão</h1>
        <div>
            <a href="/public/index.php?page=clientes" class="mr-4">Clientes</a>
            <a href="/public/index.php?page=os" class="mr-4">Ordens de Serviço</a>
            <a href="/public/index.php?page=faturas">Faturas</a>
        </div>
    </nav>
    <div class="container mx-auto p-6">
        <div class="flex justify-between items-center mb-6">
            <h2 class="text-2xl font-semibold">Ordens de Serviço</h2>
            <a href="/public/index.php?page=os&action=create" class="bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600">Nova OS</a>
        </div>
        <div class="bg-white shadow rounded-lg overflow-hidden">
            <table class="min-w-full">
                <thead class="bg-gray-200">
                    <tr>
                        <th class="py-3 px-6 text-left">Nº OS</th>
                        <th class="py-3 px-6 text-left">Cliente</th>
                        <th class="py-3 px-6 text-left">Data</th>
                        <th class="py-3 px-6 text-left">Status</th>
                        <th class="py-3 px-6 text-right">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($ordens)): ?>
                        <tr>
                            <td colspan="5" class="py-3 px-6 text-center text-gray-500">Nenhuma ordem de serviço encontrada.</td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($ordens as $ordem): ?>
                            <tr class="border-b">
                                <td class="py-3 px-6"><?php echo htmlspecialchars($ordem['numero_os']); ?></td>
                                <td class="py-3 px-6"><?php echo htmlspecialchars($ordem['cliente_nome']); ?></td>
                                <td class="py-3 px-6"><?php echo htmlspecialchars($ordem['data_emissao']); ?></td>
                                <td class="py-3 px-6">
                                    <span class="px-2 py-1 rounded <?php echo $ordem['status'] === 'Aberta' ? 'bg-yellow-200 text-yellow-800' : ($ordem['status'] === 'Concluída' ? 'bg-green-200 text-green-800' : 'bg-gray-200 text-gray-800'); ?>">
                                        <?php echo htmlspecialchars($ordem['status']); ?>
                                    </span>
                                </td>
                                <td class="py-3 px-6 text-right">
                                    <a href="/public/index.php?page=os&action=edit&id=<?php echo $ordem['id']; ?>" class="text-blue-500 hover:text-blue-700 mr-2">Editar</a>
                                    <a href="/public/index.php?page=os&action=delete&id=<?php echo $ordem['id']; ?>" class="text-red-500 hover:text-red-700" onclick="return confirm('Tem certeza que deseja excluir esta ordem de serviço?')">Excluir</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>