<!-- views/faturas/listar.php -->
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Faturas</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-100 font-sans">
    <nav class="bg-blue-600 p-4 text-white flex justify-between">
        <h1 class="text-lg font-bold">Sistema de Gestão</h1>
        <div>
            <a href="/public/index.php?page=clientes" class="mr-4">Clientes</a>
            <a href="/public/index.php?page=os" class="mr-4">Ordens de Serviço</a>
            <a href="/public/index.php?page=faturas">Faturas</a>
        </div>
    </nav>
    <div class="container mx-auto p-6">
        <div class="flex justify-between items-center mb-6">
            <h2 class="text-2xl font-semibold">Faturas</h2>
            <a href="/public/index.php?page=faturas&action=create" class="bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600">Nova Fatura</a>
        </div>
        <div class="bg-white shadow rounded-lg overflow-hidden">
            <table class="min-w-full">
                <thead class="bg-gray-200">
                    <tr>
                        <th class="py-3 px-6 text-left">Nº Fatura</th>
                        <th class="py-3 px-6 text-left">Cliente</th>
                        <th class="py-3 px-6 text-left">OS</th>
                        <th class="py-3 px-6 text-left">Valor</th>
                        <th class="py-3 px-6 text-left">Status</th>
                        <th class="py-3 px-6 text-right">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($faturas)): ?>
                        <tr>
                            <td colspan="6" class="py-3 px-6 text-center text-gray-500">Nenhuma fatura encontrada.</td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($faturas as $fatura): ?>
                            <tr class="border-b">
                                <td class="py-3 px-6"><?php echo htmlspecialchars($fatura['numero_fatura']); ?></td>
                                <td class="py-3 px-6"><?php echo htmlspecialchars($fatura['cliente_nome']); ?></td>
                                <td class="py-3 px-6"><?php echo htmlspecialchars($fatura['numero_os'] ?: 'N/A'); ?></td>
                                <td class="py-3 px-6">R$ <?php echo number_format($fatura['valor'], 2, ',', '.'); ?></td>
                                <td class="py-3 px-6">
                                    <span class="px-2 py-1 rounded <?php echo $fatura['status'] === 'Pendente' ? 'bg-yellow-200 text-yellow-800' : ($fatura['status'] === 'Pago' ? 'bg-green-200 text-green-800' : 'bg-red-200 text-red-800'); ?>">
                                        <?php echo htmlspecialchars($fatura['status']); ?>
                                    </span>
                                </td>
                                <td class="py-3 px-6 text-right">
                                    <a href="/public/index.php?page=faturas&action=edit&id=<?php echo $fatura['id']; ?>" class="text-blue-500 hover:text-blue-700 mr-2">Editar</a>
                                    <a href="/public/index.php?page=faturas&action=delete&id=<?php echo $fatura['id']; ?>" class="text-red-500 hover:text-red-700" onclick="return confirm('Tem certeza que deseja excluir esta fatura?')">Excluir</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>