<!-- views/dashboard.php -->
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
</head>
<body class="bg-gray-100 font-sans">
    <nav class="bg-blue-600 p-4 text-white flex justify-between">
        <h1 class="text-lg font-bold">Sistema de Gestão</h1>
        <div>
            <a href="/public/index.php?page=clientes" class="mr-4"><i class="fas fa-users"></i> Clientes</a>
            <a href="/public/index.php?page=os" class="mr-4"><i class="fas fa-tools"></i> Ordens de Serviço</a>
            <a href="/public/index.php?page=faturas"><i class="fas fa-file-invoice"></i> Faturas</a>
        </div>
    </nav>
    <div class="container mx-auto p-6">
        <h2 class="text-2xl font-semibold mb-6">Dashboard</h2>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div class="bg-white p-6 rounded-lg shadow">
                <h3 class="text-lg font-semibold"><i class="fas fa-users text-blue-500"></i> Clientes</h3>
                <p class="text-3xl mt-2"><?php echo count($clientes); ?></p>
            </div>
            <div class="bg-white p-6 rounded-lg shadow">
                <h3 class="text-lg font-semibold"><i class="fas fa-tools text-yellow-500"></i> OS Abertas</h3>
                <p class="text-3xl mt-2"><?php echo count(array_filter($ordens, fn($o) => $o['status'] === 'Aberta')); ?></p>
            </div>
            <div class="bg-white p-6 rounded-lg shadow">
                <h3 class="text-lg font-semibold"><i class="fas fa-file-invoice text-green-500"></i> Faturas Pendentes</h3>
                <p class="text-3xl mt-2"><?php echo count(array_filter($faturas, fn($f) => $f['status'] === 'Pendente')); ?></p>
            </div>
        </div>
    </div>
</body>
</html>