<!-- views/clientes/listar.php -->
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lista de Clientes</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-100 font-sans">
    <nav class="bg-blue-600 p-4 text-white flex justify-between">
        <h1 class="text-lg font-bold">Sistema de Gestão</h1>
        <div>
            <a href="/public/index.php?page=clientes" class="mr-4">Clientes</a>
            <a href="/public/index.php?page=os" class="mr-4">Ordens de Serviço</a>
            <a href="/public/index.php?page=faturas">Faturas</a>
        </div>
    </nav>
    <div class="container mx-auto p-6">
        <div class="flex justify-between items-center mb-6">
            <h2 class="text-2xl font-semibold">Clientes</h2>
            <a href="/public/index.php?page=clientes&action=create" class="bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600">Novo Cliente</a>
        </div>
        <div class="bg-white shadow rounded-lg overflow-hidden">
            <table class="min-w-full">
                <thead class="bg-gray-200">
                    <tr>
                        <th class="py-3 px-6 text-left">CNPJ</th>
                        <th class="py-3 px-6 text-left">Nome</th>
                        <th class="py-3 px-6 text-left">Cidade/UF</th>
                        <th class="py-3 px-6 text-right">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($clientes)): ?>
                        <tr>
                            <td colspan="4" class="py-3 px-6 text-center text-gray-500">Nenhum cliente encontrado.</td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($clientes as $cliente): ?>
                            <tr class="border-b">
                                <td class="py-3 px-6"><?php echo htmlspecialchars($cliente['cnpj']); ?></td>
                                <td class="py-3 px-6"><?php echo htmlspecialchars($cliente['nome']); ?></td>
                                <td class="py-3 px-6"><?php echo htmlspecialchars($cliente['cidade'] . '/' . $cliente['uf']); ?></td>
                                <td class="py-3 px-6 text-right">
                                    <a href="/public/index.php?page=clientes&action=edit&id=<?php echo $cliente['id']; ?>" class="text-blue-500 hover:text-blue-700 mr-2">Editar</a>
                                    <a href="/public/index.php?page=clientes&action=delete&id=<?php echo $cliente['id']; ?>" class="text-red-500 hover:text-red-700" onclick="return confirm('Tem certeza que deseja excluir este cliente?')">Excluir</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>