<!-- views/clientes/cadastrar.php -->
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cadastrar Cliente</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
</head>
<body class="bg-gray-100 font-sans">
    <nav class="bg-blue-600 p-4 text-white flex justify-between">
        <h1 class="text-lg font-bold">Sistema de Gestão</h1>
        <div>
            <a href="/public/index.php?page=clientes" class="mr-4"><i class="fas fa-users"></i> Clientes</a>
            <a href="/public/index.php?page=os" class="mr-4"><i class="fas fa-tools"></i> Ordens de Serviço</a>
            <a href="/public/index.php?page=faturas"><i class="fas fa-file-invoice"></i> Faturas</a>
        </div>
    </nav>
    <div class="container mx-auto p-6">
        <h2 class="text-2xl font-semibold mb-6">Cadastrar Cliente</h2>
        <form method="POST" class="bg-white p-6 rounded-lg shadow">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-gray-700">CNPJ</label>
                    <input type="text" name="cnpj" class="w-full p-2 border rounded" required>
                </div>
                <div>
                    <label class="block text-gray-700">Nome</label>
                    <input type="text" name="nome" class="w-full p-2 border rounded" required>
                </div>
                <div>
                    <label class="block text-gray-700">Endereço</label>
                    <input type="text" name="endereco" class="w-full p-2 border rounded">
                </div>
                <div>
                    <label class="block text-gray-700">Número</label>
                    <input type="text" name="numero" class="w-full p-2 border rounded">
                </div>
                <div>
                    <label class="block text-gray-700">Bairro</label>
                    <input type="text" name="bairro" class="w-full p-2 border rounded">
                </div>
                <div>
                    <label class="block text-gray-700">Cidade</label>
                    <input type="text" name="cidade" class="w-full p-2 border rounded">
                </div>
                <div>
                    <label class="block text-gray-700">UF</label>
                    <input type="text" name="uf" class="w-full p-2 border rounded" maxlength="2">
                </div>
            </div>
            <button type="submit" class="mt-4 bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600"><i class="fas fa-save"></i> Salvar</button>
        </form>
    </div>
</body>
</html>