<?php
// public/index.php
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../controllers/ClienteController.php';
require_once __DIR__ . '/../controllers/OrdemServicoController.php';
require_once __DIR__ . '/../controllers/FaturaController.php';

$page = $_GET['page'] ?? 'dashboard';
$action = $_GET['action'] ?? 'index';
$id = $_GET['id'] ?? null;

switch ($page) {
    case 'dashboard':
        $clienteController = new ClienteController($pdo);
        $osController = new OrdemServicoController($pdo);
        $faturaController = new FaturaController($pdo);
        
        // Verificar se os métodos existem antes de chamar
        // Ou modificar para usar métodos que existem
        $clientes = method_exists($clienteController, 'getAll') ? 
                    $clienteController->getAll() : 
                    $clienteController->index(true); // Parâmetro opcional para retornar dados em vez de renderizar
                    
        $ordens = method_exists($osController, 'getAll') ? 
                  $osController->getAll() : 
                  $osController->index(true);
                  
        $faturas = method_exists($faturaController, 'getAll') ? 
                   $faturaController->getAll() : 
                   $faturaController->index(true);
                   
        require_once __DIR__ . '/../views/dashboard.php';
        break;
    case 'clientes':
        $controller = new ClienteController($pdo);
        if ($action === 'create') {
            $controller->create();
        } elseif ($action === 'edit' && $id) {
            $controller->edit($id);
        } elseif ($action === 'delete' && $id) {
            $controller->delete($id);
        } else {
            $controller->index();
        }
        break;
    case 'os':
        $controller = new OrdemServicoController($pdo);
        if ($action === 'create') {
            $controller->create();
        } elseif ($action === 'edit' && $id) {
            $controller->edit($id);
        } elseif ($action === 'delete' && $id) {
            $controller->delete($id);
        } else {
            $controller->index();
        }
        break;
    case 'faturas':
        $controller = new FaturaController($pdo);
        if ($action === 'create') {
            $controller->create();
        } elseif ($action === 'edit' && $id) {
            $controller->edit($id);
        } elseif ($action === 'delete' && $id) {
            $controller->delete($id);
        } else {
            $controller->index();
        }
        break;
    default:
        echo "Página não encontrada.";
}
?>