<?php
// models/OrdemServico.php

require_once __DIR__ . '/../config/database.php';

class OrdemServico {
    private $pdo;

    public function __construct($pdo) {
        $this->pdo = $pdo;
    }

    public function create($numero_os, $cliente_id, $data_emissao, $descricao, $referencia, $periodo, $status, $valor_estimado) {
        $stmt = $this->pdo->prepare("INSERT INTO ordens_servico (numero_os, cliente_id, data_emissao, descricao, referencia, periodo, status, valor_estimado) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        return $stmt->execute([$numero_os, $cliente_id, $data_emissao, $descricao, $referencia, $periodo, $status, $valor_estimado]);
    }

    public function getAll() {
        $stmt = $this->pdo->query("SELECT os.*, c.nome AS cliente_nome FROM ordens_servico os JOIN clientes c ON os.cliente_id = c.id ORDER BY os.data_emissao DESC");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getById($id) {
        $stmt = $this->pdo->prepare("SELECT os.*, c.nome AS cliente_nome FROM ordens_servico os JOIN clientes c ON os.cliente_id = c.id WHERE os.id = ?");
        $stmt->execute([$id]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function update($id, $numero_os, $cliente_id, $data_emissao, $descricao, $referencia, $periodo, $status, $valor_estimado) {
        $stmt = $this->pdo->prepare("UPDATE ordens_servico SET numero_os = ?, cliente_id = ?, data_emissao = ?, descricao = ?, referencia = ?, periodo = ?, status = ?, valor_estimado = ? WHERE id = ?");
        return $stmt->execute([$numero_os, $cliente_id, $data_emissao, $descricao, $referencia, $periodo, $status, $valor_estimado, $id]);
    }

    public function delete($id) {
        $stmt = $this->pdo->prepare("DELETE FROM ordens_servico WHERE id = ?");
        return $stmt->execute([$id]);
    }
}
?>