<?php
// models/Cliente.php

require_once __DIR__ . '/../config/database.php';

class Cliente {
    private $pdo;

    public function __construct($pdo) {
        $this->pdo = $pdo;
    }

    public function create($cnpj, $nome, $endereco, $numero, $bairro, $cidade, $uf) {
        $stmt = $this->pdo->prepare("INSERT INTO clientes (cnpj, nome, endereco, numero, bairro, cidade, uf) VALUES (?, ?, ?, ?, ?, ?, ?)");
        return $stmt->execute([$cnpj, $nome, $endereco, $numero, $bairro, $cidade, $uf]);
    }

    public function getAll() {
        $stmt = $this->pdo->query("SELECT * FROM clientes ORDER BY nome");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getById($id) {
        $stmt = $this->pdo->prepare("SELECT * FROM clientes WHERE id = ?");
        $stmt->execute([$id]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function update($id, $cnpj, $nome, $endereco, $numero, $bairro, $cidade, $uf) {
        $stmt = $this->pdo->prepare("UPDATE clientes SET cnpj = ?, nome = ?, endereco = ?, numero = ?, bairro = ?, cidade = ?, uf = ? WHERE id = ?");
        return $stmt->execute([$cnpj, $nome, $endereco, $numero, $bairro, $cidade, $uf, $id]);
    }

    public function delete($id) {
        $stmt = $this->pdo->prepare("DELETE FROM clientes WHERE id = ?");
        return $stmt->execute([$id]);
    }
}
?>