<?php
// controllers/ClienteController.php

require_once __DIR__ . '/../models/Cliente.php';

class ClienteController {
    private $cliente;

    public function __construct($pdo) {
        $this->cliente = new Cliente($pdo);
    }

    public function index() {
        $clientes = $this->cliente->getAll();
        require_once __DIR__ . '/../views/clientes/listar.php';
    }

    public function create() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $this->cliente->create($_POST['cnpj'], $_POST['nome'], $_POST['endereco'], $_POST['numero'], $_POST['bairro'], $_POST['cidade'], $_POST['uf']);
            header('Location: /public/index.php?page=clientes');
        } else {
            require_once __DIR__ . '/../views/clientes/cadastrar.php';
        }
    }

    public function edit($id) {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $this->cliente->update($id, $_POST['cnpj'], $_POST['nome'], $_POST['endereco'], $_POST['numero'], $_POST['bairro'], $_POST['cidade'], $_POST['uf']);
            header('Location: /public/index.php?page=clientes');
        } else {
            $cliente = $this->cliente->getById($id);
            require_once __DIR__ . '/../views/clientes/editar.php';
        }
    }

    public function delete($id) {
        $this->cliente->delete($id);
        header('Location: /public/index.php?page=clientes');
    }
}
?>